#ifndef SIMPLESERIAL_ANALYZER_H
#define SIMPLESERIAL_ANALYZER_H

#include <Analyzer.h>
#include "SimpleSerialAnalyzerResults.h"
#include "SimpleSerialSimulationDataGenerator.h"

//#define NEW_SDK



struct SingleByte {
	U16 val;
	U64 firstSample;
	U64 lastSample;
};

#define VAL_START					0x100
#define VAL_STOP					0x101
#define VAL_PHASE_ERROR				0x102

class SimpleSerialAnalyzerSettings;
class ANALYZER_EXPORT SimpleSerialAnalyzer :
	
	#ifdef NEW_SDK
		public Analyzer2
	#else
		public Analyzer
	#endif
{
public:
	SimpleSerialAnalyzer();
	virtual ~SimpleSerialAnalyzer();
	virtual void WorkerThread();

	virtual U32 GenerateSimulationData( U64 newest_sample_requested, U32 sample_rate, SimulationChannelDescriptor** simulation_channels );
	virtual U32 GetMinimumSampleRateHz();

	virtual const char* GetAnalyzerName() const;
	virtual bool NeedsRerun();

	#ifdef NEW_SDK
		virtual void SetupResults();
	#endif

protected: //vars
	std::auto_ptr< SimpleSerialAnalyzerSettings > mSettings;
	std::auto_ptr< SimpleSerialAnalyzerResults > mResults;

	AnalyzerChannelData* mPin1;
	AnalyzerChannelData* mPin5;

	SimpleSerialSimulationDataGenerator mSimulationDataGenerator;
	bool mSimulationInitilized;

	//Serial analysis vars:
	U32 mSampleRateHz;
	U32 mStartOfStopBitOffset;
	U32 mEndOfStopBitOffset;

private:
	bool RxNextBit(char *phase);
	void RxWaitBothHigh(void);

	void bytesAdd(U16 val, U64 first, U64 last);
	void showBytes(void);
	void sendFrame(Frame &f);
	struct SingleByte *mBytes;
	U32 mNumBytes, mNumBytesCapacity;
};

extern "C" ANALYZER_EXPORT const char* __cdecl GetAnalyzerName();
extern "C" ANALYZER_EXPORT Analyzer* __cdecl CreateAnalyzer( );
extern "C" ANALYZER_EXPORT void __cdecl DestroyAnalyzer( Analyzer* analyzer );

#endif //SIMPLESERIAL_ANALYZER_H
